/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.duibaboot.oss.conf;

import cn.com.duiba.duiba.base.service.api.duibaboot.oss.conf.OssProps;
import cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.PrivateBucketOssTemplate;
import cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.PublicBucketOssTemplate;
import com.aliyun.oss.OSSClient;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class OssBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(OssBeanDefinitionRegistryPostProcessor.class);
    private OssProps ossProps;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (Objects.isNull(this.ossProps) || MapUtils.isEmpty(this.ossProps.getOss())) {
            return;
        }
        for (Map.Entry<String, OssProps.OssClientProps> entity : this.ossProps.getOss().entrySet()) {
            String beanNamePrefix = entity.getKey();
            OssProps.OssClientProps ossProps = entity.getValue();
            OSSClient ossClient = ossProps.newInstance();
            if (Objects.isNull(ossClient)) {
                return;
            }
            BeanDefinitionBuilder bdb = ossProps.isPrivateBucket() ? BeanDefinitionBuilder.genericBeanDefinition(PrivateBucketOssTemplate.class) : BeanDefinitionBuilder.genericBeanDefinition(PublicBucketOssTemplate.class);
            bdb.addPropertyValue("ossClient", (Object)ossClient).addPropertyValue("bucketName", (Object)ossProps.getBucketName()).addPropertyValue("cdnDomain", (Object)ossProps.getCDNDomain()).addPropertyValue("endPoint", (Object)ossProps.getEndPoint());
            String beanName = beanNamePrefix + "OssTemplate";
            registry.registerBeanDefinition(beanName, (BeanDefinition)bdb.getBeanDefinition());
            log.info("register bean {} successful", (Object)beanName);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.ossProps = (OssProps)Binder.get((Environment)environment).bindOrCreate("apollo", OssProps.class);
    }
}

