/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.id.generator.service;

import cn.com.duiba.duiba.base.service.api.id.generator.bean.IdGeneratorKey;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.IdGeneratorProperties;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.Scene;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.TimeLevel;
import cn.com.duiba.duiba.base.service.api.id.generator.exception.IdGeneratorException;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGeneratorCache {
    private static final Logger log = LoggerFactory.getLogger(IdGeneratorCache.class);
    private RedisAtomicClient redisAtomicClient;
    private IdGeneratorProperties idGeneratorProperties;
    private Scene scene;
    private IdGeneratorKey key;
    private ExecutorService executorService;
    private int loadingThreshold;
    private final LinkedBlockingQueue<Long> idQueue = new LinkedBlockingQueue();
    private static final int WARN_TIME = 500;
    private static final int INFO_TIME = 100;

    public IdGeneratorCache(RedisAtomicClient redisAtomicClient, IdGeneratorProperties idGeneratorProperties) {
        this.redisAtomicClient = redisAtomicClient;
        this.idGeneratorProperties = idGeneratorProperties;
    }

    public void init() {
        int nThreads = Math.max(this.idGeneratorProperties.getScenes().size(), 1);
        this.executorService = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("id-generator"));
        this.loadingThreshold = this.scene.getStep() / 2;
        this.initStart();
        this.loadId();
    }

    public boolean isInvalidate() {
        String time = this.scene.getTimeLevel().formatTime(new Date());
        return !StringUtils.equals((CharSequence)this.key.getTime(), (CharSequence)time);
    }

    public Long get() throws IdGeneratorException {
        if (Objects.equals(1, this.scene.getStep())) {
            return this.incrBy(this.getRedisKey(), 1L);
        }
        long start = System.currentTimeMillis();
        try {
            if (this.idQueue.isEmpty()) {
                this.loadId();
            } else if (this.idQueue.size() < this.loadingThreshold) {
                this.executorService.execute(this::loadId);
            }
        }
        finally {
            this.log(start, "loadId");
        }
        start = System.currentTimeMillis();
        try {
            Long l = this.idQueue.poll(1L, TimeUnit.SECONDS);
            return l;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IdGeneratorException("\u53d1\u53f7\u8d85\u65f6");
        }
        finally {
            this.log(start, "poll");
        }
    }

    private void log(long start, String biz) {
        long cost = System.currentTimeMillis() - start;
        if (cost > 500L) {
            log.warn("IdGenerator, {} limit {} ms, cost={}ms", new Object[]{biz, 500, cost});
        } else if (cost > 100L) {
            log.info("IdGenerator, {} limit {} ms, cost={}ms", new Object[]{biz, 100, cost});
        }
    }

    private String getRedisKey() {
        return this.key.getSceneKey() + "_" + this.key.getTime();
    }

    private String getLockKey() {
        return this.key.getSceneKey();
    }

    private synchronized void loadId() {
        if (Objects.equals(1L, this.scene.getStep())) {
            return;
        }
        if (this.idQueue.size() >= this.scene.getStep()) {
            return;
        }
        long delta = this.scene.getStep();
        Long result = this.incrBy(this.getRedisKey(), delta);
        if (result == null || result < delta) {
            log.error("IdGenerator, incr error, key={}, delta={}, result={}", new Object[]{this.key.getSceneKey(), delta, result});
            return;
        }
        for (long i = result - delta; i < result; ++i) {
            this.idQueue.add(i + 1L);
        }
    }

    private void initStart() {
        if (this.scene.getStartId() == 0L) {
            return;
        }
        try (RedisLock lock = this.redisAtomicClient.getLock(this.getLockKey(), 10L, 5, 50L);){
            if (lock == null) {
                log.warn("IdGenerator, initStart lock is null, key={}, ", (Object)this.key.getSceneKey());
            }
            this.doInitStart();
        }
        catch (Exception e) {
            log.error("IdGenerator, initStart error, key={}, ", (Object)this.key.getSceneKey(), (Object)e);
            this.doInitStart();
        }
    }

    private void doInitStart() {
        String redisKey = this.getRedisKey();
        Long exist = this.redisAtomicClient.getLong(redisKey);
        if (exist != null && exist >= this.scene.getStartId()) {
            return;
        }
        long delta = exist == null ? this.scene.getStartId() : this.scene.getStartId() - exist;
        Long result = this.incrBy(redisKey, delta);
        if (result == null || result < this.scene.getStartId()) {
            throw new IdGeneratorException("\u53d1\u53f7\u573a\u666f[" + this.key.getSceneKey() + "]\u521d\u59cb\u5316\u542f\u59cb\u503c\u5931\u8d25");
        }
        log.info("IdGenerator, start init, startId={}, redisKey={}, delta={}", new Object[]{this.scene.getStartId(), redisKey, delta});
    }

    private Long incrBy(String redisKey, long delta) {
        return this.redisAtomicClient.incrBy(redisKey, delta, this.getTimeout() + 1L, TimeUnit.HOURS);
    }

    private long getTimeout() {
        TimeLevel timeLevel = this.scene.getTimeLevel();
        switch (timeLevel) {
            case NONE: {
                return 878400L;
            }
            case YEAR: {
                return 8784L;
            }
            case MONTH: {
                return 744L;
            }
        }
        return 24L;
    }

    public RedisAtomicClient getRedisAtomicClient() {
        return this.redisAtomicClient;
    }

    public IdGeneratorProperties getIdGeneratorProperties() {
        return this.idGeneratorProperties;
    }

    public Scene getScene() {
        return this.scene;
    }

    public IdGeneratorKey getKey() {
        return this.key;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public int getLoadingThreshold() {
        return this.loadingThreshold;
    }

    public LinkedBlockingQueue<Long> getIdQueue() {
        return this.idQueue;
    }

    public void setRedisAtomicClient(RedisAtomicClient redisAtomicClient) {
        this.redisAtomicClient = redisAtomicClient;
    }

    public void setIdGeneratorProperties(IdGeneratorProperties idGeneratorProperties) {
        this.idGeneratorProperties = idGeneratorProperties;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void setKey(IdGeneratorKey key) {
        this.key = key;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setLoadingThreshold(int loadingThreshold) {
        this.loadingThreshold = loadingThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdGeneratorCache)) {
            return false;
        }
        IdGeneratorCache other = (IdGeneratorCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisAtomicClient this$redisAtomicClient = this.getRedisAtomicClient();
        RedisAtomicClient other$redisAtomicClient = other.getRedisAtomicClient();
        if (this$redisAtomicClient == null ? other$redisAtomicClient != null : !this$redisAtomicClient.equals(other$redisAtomicClient)) {
            return false;
        }
        IdGeneratorProperties this$idGeneratorProperties = this.getIdGeneratorProperties();
        IdGeneratorProperties other$idGeneratorProperties = other.getIdGeneratorProperties();
        if (this$idGeneratorProperties == null ? other$idGeneratorProperties != null : !((Object)this$idGeneratorProperties).equals(other$idGeneratorProperties)) {
            return false;
        }
        Scene this$scene = this.getScene();
        Scene other$scene = other.getScene();
        if (this$scene == null ? other$scene != null : !((Object)this$scene).equals(other$scene)) {
            return false;
        }
        IdGeneratorKey this$key = this.getKey();
        IdGeneratorKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        if (this.getLoadingThreshold() != other.getLoadingThreshold()) {
            return false;
        }
        LinkedBlockingQueue<Long> this$idQueue = this.getIdQueue();
        LinkedBlockingQueue<Long> other$idQueue = other.getIdQueue();
        return !(this$idQueue == null ? other$idQueue != null : !this$idQueue.equals(other$idQueue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdGeneratorCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisAtomicClient $redisAtomicClient = this.getRedisAtomicClient();
        result = result * 59 + ($redisAtomicClient == null ? 43 : $redisAtomicClient.hashCode());
        IdGeneratorProperties $idGeneratorProperties = this.getIdGeneratorProperties();
        result = result * 59 + ($idGeneratorProperties == null ? 43 : ((Object)$idGeneratorProperties).hashCode());
        Scene $scene = this.getScene();
        result = result * 59 + ($scene == null ? 43 : ((Object)$scene).hashCode());
        IdGeneratorKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        result = result * 59 + this.getLoadingThreshold();
        LinkedBlockingQueue<Long> $idQueue = this.getIdQueue();
        result = result * 59 + ($idQueue == null ? 43 : $idQueue.hashCode());
        return result;
    }

    public String toString() {
        return "IdGeneratorCache(redisAtomicClient=" + this.getRedisAtomicClient() + ", idGeneratorProperties=" + this.getIdGeneratorProperties() + ", scene=" + this.getScene() + ", key=" + this.getKey() + ", executorService=" + this.getExecutorService() + ", loadingThreshold=" + this.getLoadingThreshold() + ", idQueue=" + this.getIdQueue() + ")";
    }
}

