/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.impl;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSqlCommandHandler
implements SqlCommandHandler {
    protected static final String LOWER_SET = "set";
    protected static final String LOWER_WHERE = "where";
    protected static final String SPACE = " ";
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    protected static final String LOWER_AND = "and";
    protected static final String LOWER_IN = "in";
    protected static final String LOWER_CASE = "case";
    protected static final String LOWER_WHEN = "when";

    protected String getTableName(String sql, String ... separators) {
        if (sql == null || sql.isEmpty()) {
            return null;
        }
        int tbIndex = sql.indexOf("tb_");
        if (tbIndex < 0) {
            return null;
        }
        int index = this.getTableNameEndIndex(sql, tbIndex, separators);
        if (index < 0) {
            return sql.substring(tbIndex);
        }
        if (tbIndex >= index) {
            return null;
        }
        String substring = sql.substring(tbIndex, index);
        return substring.trim();
    }

    private int getTableNameEndIndex(String sql, int fromIndex, String ... separators) {
        int minIndex = -1;
        for (String separator : separators) {
            int index = AbstractSqlCommandHandler.getIndexIgnoreCase(sql, separator, fromIndex);
            if (minIndex < 0) {
                minIndex = index;
            }
            if (index <= 0 || index >= minIndex) continue;
            minIndex = index;
        }
        return minIndex;
    }

    private static int getIndexIgnoreCase(String str, String separator, int fromIndex) {
        return str.toLowerCase().indexOf(separator.toLowerCase(), fromIndex);
    }

    private static int getIndexIgnoreCase(String str, String separator) {
        return str.toLowerCase().indexOf(separator.toLowerCase());
    }

    @Override
    public Map<Integer, DbEncryptColumnRule> getNeedEncryptParamIndexRule(String sql, Map<String, DbEncryptColumnRule> columns) {
        LinkedHashMap<Integer, DbEncryptColumnRule> indexRuleMap = new LinkedHashMap<Integer, DbEncryptColumnRule>();
        if (StringUtils.isBlank((CharSequence)sql)) {
            return indexRuleMap;
        }
        int index = AbstractSqlCommandHandler.putIndexRuleBySet(sql, columns, indexRuleMap);
        AbstractSqlCommandHandler.putIndexRuleByWhere(sql, index, columns, indexRuleMap);
        return indexRuleMap;
    }

    protected static int putIndexRuleBySet(String sql, Map<String, DbEncryptColumnRule> columns, Map<Integer, DbEncryptColumnRule> indexRuleMap) {
        String[] split;
        int index = 0;
        int setIndex = AbstractSqlCommandHandler.getIndexIgnoreCase(sql, LOWER_SET);
        if (setIndex < 0) {
            return index;
        }
        int whereIndex = AbstractSqlCommandHandler.getIndexIgnoreCase(sql, LOWER_WHERE);
        if (whereIndex < 0) {
            return index;
        }
        String setSql = sql.substring(setIndex + LOWER_SET.length(), whereIndex);
        for (String s : split = setSql.split(",")) {
            int questionMarkIndex = s.indexOf("?");
            if (questionMarkIndex < 0) continue;
            int addIndex = AbstractSqlCommandHandler.putSetValue(s, ++index, questionMarkIndex, columns, indexRuleMap);
            index += addIndex;
        }
        return index;
    }

    private static int putSetValue(String s, int index, int questionMarkIndex, Map<String, DbEncryptColumnRule> columns, Map<Integer, DbEncryptColumnRule> indexRuleMap) {
        int equalSignIndex = s.indexOf("=");
        if (equalSignIndex < 0) {
            return 0;
        }
        int caseIndex = AbstractSqlCommandHandler.getIndexIgnoreCase(s, LOWER_CASE);
        if (caseIndex < 0) {
            AbstractSqlCommandHandler.putEqualSign(s, index, questionMarkIndex, equalSignIndex, columns, indexRuleMap);
            return 0;
        }
        AbstractSqlCommandHandler.putCase(s, index, questionMarkIndex, equalSignIndex, caseIndex, columns, indexRuleMap);
        int questionCount = AbstractSqlCommandHandler.getQuestionCount(s);
        return questionCount - 1;
    }

    private static int getQuestionCount(String str) {
        int count = 0;
        char question = "?".toCharArray()[0];
        for (char c : str.toCharArray()) {
            if (c != question) continue;
            ++count;
        }
        return count;
    }

    protected static int putIndexRuleByWhere(String sql, int index, Map<String, DbEncryptColumnRule> columns, Map<Integer, DbEncryptColumnRule> indexRuleMap) {
        String[] split;
        int whereIndex = AbstractSqlCommandHandler.getIndexIgnoreCase(sql, LOWER_WHERE);
        if (whereIndex < 0) {
            return index;
        }
        String sqlAfterWhere = sql.substring(whereIndex + LOWER_WHERE.length());
        for (String s : split = sqlAfterWhere.split(LOWER_AND)) {
            int questionMarkIndex = s.indexOf("?");
            if (questionMarkIndex < 0) continue;
            ++index;
            int equalSignIndex = s.indexOf("=");
            if (equalSignIndex >= 0) {
                AbstractSqlCommandHandler.putEqualSign(s, index, questionMarkIndex, equalSignIndex, columns, indexRuleMap);
                continue;
            }
            int inIndex = AbstractSqlCommandHandler.getIndexIgnoreCase(s, LOWER_IN);
            if (inIndex < 0) continue;
            index = AbstractSqlCommandHandler.putIn(s, index, questionMarkIndex, inIndex, columns, indexRuleMap);
        }
        return index;
    }

    private static int putIn(String s, int index, int questionMarkIndex, int inIndex, Map<String, DbEncryptColumnRule> columns, Map<Integer, DbEncryptColumnRule> indexRuleMap) {
        if (questionMarkIndex < inIndex) {
            return index;
        }
        String columnName = (s = s.substring(0, s.indexOf(")"))).substring(0, inIndex).trim();
        DbEncryptColumnRule rule = columns.get(columnName);
        if (rule == null) {
            return index;
        }
        while (questionMarkIndex >= 0) {
            indexRuleMap.put(index - 1, rule);
            if ((questionMarkIndex = s.indexOf("?", questionMarkIndex + 1)) < 0) continue;
            ++index;
        }
        return index;
    }

    private static void putEqualSign(String s, int index, int questionMarkIndex, int equalSignIndex, Map<String, DbEncryptColumnRule> columns, Map<Integer, DbEncryptColumnRule> indexRuleMap) {
        if (questionMarkIndex < equalSignIndex) {
            return;
        }
        String columnName = s.substring(0, equalSignIndex).trim();
        DbEncryptColumnRule rule = columns.get(columnName);
        if (rule == null) {
            return;
        }
        indexRuleMap.put(index - 1, rule);
    }

    private static void putCase(String s, int index, int questionMarkIndex, int equalSignIndex, int caseIndex, Map<String, DbEncryptColumnRule> columns, Map<Integer, DbEncryptColumnRule> indexRuleMap) {
        if (questionMarkIndex < equalSignIndex) {
            return;
        }
        String columnName = s.substring(0, equalSignIndex).trim();
        DbEncryptColumnRule rule = columns.get(columnName);
        String whenColumnName = s.substring(caseIndex + LOWER_CASE.length(), AbstractSqlCommandHandler.getIndexIgnoreCase(s, LOWER_WHEN)).trim();
        DbEncryptColumnRule whenRule = columns.get(whenColumnName);
        if (rule == null && whenRule == null) {
            return;
        }
        boolean isWhen = true;
        while (questionMarkIndex >= 0) {
            DbEncryptColumnRule r;
            DbEncryptColumnRule dbEncryptColumnRule = r = isWhen ? whenRule : rule;
            if (r != null) {
                indexRuleMap.put(index - 1, r);
            }
            if ((questionMarkIndex = s.indexOf("?", questionMarkIndex + 1)) >= 0) {
                ++index;
            }
            isWhen = !isWhen;
        }
    }
}

