package cn.com.duiba.duiba.base.service.api.mybatis.plugins.auto;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.DbEncryptionPlugin;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.QyDbEncryptProperties;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.alibaba.fastjson.JSON;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import javax.annotation.Resource;
import java.util.Properties;

/**
 * @author lizhi
 * @date 2024/10/9 11:50
 */
@EnableConfigurationProperties({QyDbEncryptProperties.class})
public class QyMybatisBeanPostProcessor implements SpecifiedBeanPostProcessor<Object> {

    @Resource
    private QyDbEncryptProperties qyDbEncryptProperties;

    @Override
    public int getOrder() {
        return -1;
    }

    @Override
    public Class<Object> getBeanType() {
        return Object.class;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        SqlSessionFactory s = null;
        if(bean instanceof SqlSessionFactory){
            s = (SqlSessionFactory)bean;
        }
        if(bean instanceof SqlSessionTemplate){
            s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
        }
        if(s == null){
            return bean;
        }

        addInterceptor(s);

        return bean;
    }

    private void addInterceptor(SqlSessionFactory s){
        DbEncryptionPlugin plugin = new DbEncryptionPlugin();
        Properties properties = new Properties();
        properties.put("secretMap", JSON.toJSONString(qyDbEncryptProperties.getSecrets()));
        properties.put("tables", JSON.toJSONString(qyDbEncryptProperties.getTables()));
        plugin.setProperties(properties);
        s.getConfiguration().addInterceptor(plugin);
    }
}
