package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.impl;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.enums.EncryptorEnum;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionAdapter;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionHandler;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.utils.SM4Util;
import org.springframework.stereotype.Service;

/**
 * @author lizhi
 * @date 2024/10/9 10:22
 */
@Service
public class Sm4Handler implements EncryptionDecryptionHandler {
    
    @Override
    public EncryptorEnum encryptorEnum() {
        return EncryptorEnum.S;
    }

    @Override
    public String encrypt(String value, String secret) {
        return SM4Util.encryptEcb(secret, value);
    }

    @Override
    public String decrypt(String value, String secret) {
        return SM4Util.decryptEcb(secret, value);
    }

    @Override
    public void afterPropertiesSet() {
        EncryptionDecryptionAdapter.register(this);
    }
}
