package cn.com.duiba.duiba.base.service.api.mybatis.plugins.utils;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionAdapter;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/12/10 18:28
 */
public class DecryptionUtils {
    
    private DecryptionUtils() {}
    
    private Map<String, String> secrets;
    
    public static DecryptionUtils build(Map<String, String> secretMap) {
        DecryptionUtils utils = new DecryptionUtils();
        utils.secrets = secretMap;
        return utils;
    }

    /**
     * 批量解密
     * @param values 密文
     * @return key：密文，value：明文
     */
    public Map<String, String> decryptString(Set<String> values) throws IllegalAccessException {
        if (secrets == null) {
            throw new IllegalAccessException("请设置密钥后使用");
        }
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        return values.stream().collect(Collectors.toMap(Function.identity(), v -> EncryptionDecryptionAdapter.decryptString(v, secrets)));
    }
}
