package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.message.Metric;
import cn.com.duiba.cat.message.spi.MessageManager;

public class DefaultMetric extends AbstractMessage implements Metric {

    private MessageManager manager;

    public DefaultMetric(String type, String name) {
        super(type, name);
    }

    public DefaultMetric(String type, String name, MessageManager manager) {
        super(type, name);

        this.manager = manager;
    }

    @Override
    public void complete() {
        setCompleted(true);

        if (manager != null) {
            manager.add(this);
        }
    }
}
