package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageManager;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.message.spi.internal.NullMessageTree;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.DefaultClientConfigService;

public class NullMessageManager implements MessageManager {

    public static final NullMessageManager NULL_MESSAGE_MANAGER = new NullMessageManager();

    @Override
    public void add(Message message) {
    }

    @Override
    public void end(Transaction transaction) {

    }

    @Override
    public ClientConfigService getConfigService() {
        return DefaultClientConfigService.getInstance();
    }

    @Override
    public DefaultMessageManager.Context getContext() {
        return null;
    }

    @Override
    public String getDomain() {
        return NullMessageTree.NULL_MESSAGE_TREE.getDomain();
    }

    @Override
    public Transaction getPeekTransaction() {
        return NullMessage.TRANSACTION;
    }

    @Override
    public MessageTree getThreadLocalMessageTree() {
        return NullMessageTree.NULL_MESSAGE_TREE;
    }

    @Override
    public boolean hasContext() {
        return false;
    }

    @Override
    public boolean isCatEnabled() {
        return false;
    }

    @Override
    public boolean isMessageEnabled() {
        return false;
    }

    @Override
    public boolean isTraceMode() {
        return false;
    }

    @Override
    public void setTraceMode(boolean traceMode) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setup() {
    }

    @Override
    public void start(Transaction transaction, boolean forked) {
    }

}
