package cn.com.duiba.cat.message.spi;

import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.DefaultMessageManager;
import cn.com.duiba.cat.model.configuration.ClientConfigService;

/**
 * Message manager to help build CAT message.
 * <p>
 * <p>
 * Notes: This method is reserved for internal usage only. Application developer should never call this method directly.
 */
public interface MessageManager {

    void add(Message message);

    void end(Transaction transaction);

    ClientConfigService getConfigService();

    String getDomain();

    Transaction getPeekTransaction();

    MessageTree getThreadLocalMessageTree();

    boolean hasContext();

    boolean isCatEnabled();

    boolean isMessageEnabled();

    boolean isTraceMode();

    void setTraceMode(boolean traceMode);

    void reset();

    void setup();

    void start(Transaction transaction, boolean forked);

    DefaultMessageManager.Context getContext();

}
