package cn.com.duiba.cat.message.spi;

import cn.com.duiba.cat.message.*;
import cn.com.duiba.cat.message.internal.MessageId;
import io.netty.buffer.ByteBuf;

import java.util.List;

public interface MessageTree extends Cloneable {

    void addForkableTransaction(ForkableTransaction forkableTransaction);

    boolean canDiscard();

    MessageTree copy();

    List<Event> findOrCreateEvents();

    List<Heartbeat> findOrCreateHeartbeats();

    List<Metric> findOrCreateMetrics();

    List<Transaction> findOrCreateTransactions();

    ByteBuf getBuffer();

    String getDomain();

    void setDomain(String domain);

    List<Event> getEvents();

    List<ForkableTransaction> getForkableTransactions();

    MessageId getFormatMessageId();

    void setFormatMessageId(MessageId messageId);

    List<Heartbeat> getHeartbeats();

    String getHostName();

    void setHostName(String hostName);

    String getIpAddress();

    void setIpAddress(String ipAddress);

    Message getMessage();

    void setMessage(Message message);

    String getMessageId();

    void setMessageId(String messageId);

    List<Metric> getMetrics();

    String getParentMessageId();

    void setParentMessageId(String parentMessageId);

    String getRootMessageId();

    void setRootMessageId(String rootMessageId);

    String getSessionToken();

    void setSessionToken(String session);

    String getThreadGroupName();

    void setThreadGroupName(String name);

    String getThreadId();

    void setThreadId(String threadId);

    String getThreadName();

    void setThreadName(String id);

    List<Transaction> getTransactions();

    boolean isHitSample();

    void setHitSample(boolean hitSample);

    void setDiscardPrivate(boolean discard);

    boolean isProcessLoss();

    void setProcessLoss(boolean loss);

    void setDiscard(boolean discard);

}
