package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Bind extends BaseEntity<Bind> {

    private String ip;
    private int    port;

    public Bind() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitBind(this);
    }

    @Override
    public void mergeAttributes(Bind other) {
        if (other.getIp() != null) {
            ip = other.getIp();
        }

        port = other.getPort();
    }

    public String getIp() {
        return ip;
    }

    public Bind setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public int getPort() {
        return port;
    }

    public Bind setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Bind bind = (Bind) o;

        return new EqualsBuilder().append(port, bind.port).append(ip, bind.ip).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(ip).append(port).toHashCode();
    }
}
