package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.Constants;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Domain extends BaseEntity<Domain> {

    private String  id;
    private String  ip;
    private boolean enabled        = true;
    private int     maxMessageSize = 1000;

    public Domain() {
    }

    public Domain(String id) {
        this.id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    @Override
    public void mergeAttributes(Domain other) {
        assertAttributeEquals(other, Constants.ENTITY_DOMAIN, Constants.ATTR_ID, id, other.getId());

        if (other.getIp() != null) {
            ip = other.getIp();
        }

        enabled = other.isEnabled();

        maxMessageSize = other.getMaxMessageSize();
    }

    public String getId() {
        return id;
    }

    public Domain setId(String id) {
        this.id = id;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public Domain setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public Domain setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getMaxMessageSize() {
        return maxMessageSize;
    }

    public Domain setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Domain domain = (Domain) o;

        return new EqualsBuilder().append(enabled, domain.enabled).append(maxMessageSize, domain.maxMessageSize).append(id, domain.id).append(ip, domain.ip).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(id).append(ip).append(enabled).append(maxMessageSize).toHashCode();
    }
}
