package cn.com.duiba.cat.model.configuration.client.entity;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Server {

    private String ip;
    private int    port     = 2280;
    private int    httpPort = 8080;
    private int    weight   = 100;

    public Server() {
    }

    public Server(String ip) {
        this.ip = ip;
    }

    public Server(String ip, int httpPort) {
        this.ip = ip;
        this.httpPort = httpPort;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getHttpPort() {
        return httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public String toString() {
        return "Server{" + "ip='" + ip + '\'' + ", port=" + port + ", httpPort=" + httpPort + ", weight=" + weight + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Server server = (Server) o;

        return new EqualsBuilder().append(port, server.port).append(httpPort, server.httpPort).append(weight, server.weight).append(ip, server.ip).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(ip).append(port).append(httpPort).append(weight).toHashCode();
    }
}
