package cn.com.duiba.cat.model.configuration.property.entity;

import cn.com.duiba.cat.model.configuration.property.BaseEntity;
import cn.com.duiba.cat.model.configuration.property.IVisitor;

import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyConfig extends BaseEntity<PropertyConfig> {

    private Map<String, Property> properties = new LinkedHashMap<String, Property>();

    public PropertyConfig() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitPropertyConfig(this);
    }

    public PropertyConfig addProperty(Property property) {
        properties.put(property.getId(), property);
        return this;
    }

    public Property findProperty(String id) {
        return properties.get(id);
    }

    public Map<String, Property> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    @Override
    public void mergeAttributes(PropertyConfig other) {
    }

    public boolean removeProperty(String id) {
        if (properties.containsKey(id)) {
            properties.remove(id);
            return true;
        }

        return false;
    }

}
