package cn.com.duiba.cat.status;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class StatusExtensionRegister {

    private static final StatusExtensionRegister register   = new StatusExtensionRegister();
    private              List<StatusExtension>   extensions = new CopyOnWriteArrayList<StatusExtension>();

    private StatusExtensionRegister() {
    }

    public static StatusExtensionRegister getInstance() {
        return register;
    }

    public List<StatusExtension> getStatusExtension() {
        return extensions;
    }

    public void register(StatusExtension extension) {
        extensions.add(extension);
    }

    public void unregister(StatusExtension extension) {
        extensions.remove(extension);
    }
}
