package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import static cn.com.duiba.cat.status.model.Constants.ATTR_KEY;
import static cn.com.duiba.cat.status.model.Constants.ENTITY_CUSTOMINFO;

public class CustomInfo extends BaseEntity<CustomInfo> {

    private String key;
    private String value;

    public CustomInfo() {
    }

    public CustomInfo(String key) {
        this.key = key;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitCustomInfo(this);
    }

    @Override
    public void mergeAttributes(CustomInfo other) {
        assertAttributeEquals(other, ENTITY_CUSTOMINFO, ATTR_KEY, key, other.getKey());

        if (other.getValue() != null) {
            value = other.getValue();
        }
    }

    public String getKey() {
        return key;
    }

    public CustomInfo setKey(String key) {
        this.key = key;
        return this;
    }

    public String getValue() {
        return value;
    }

    public CustomInfo setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        CustomInfo that = (CustomInfo) o;

        return new EqualsBuilder().append(key, that.key).append(value, that.value).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(key).append(value).toHashCode();
    }
}
