package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;

public class MessageInfo extends BaseEntity<MessageInfo> {

    private long produced;
    private long overflowed;
    private long bytes;

    public MessageInfo() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitMessage(this);
    }

    @Override
    public void mergeAttributes(MessageInfo other) {
        produced = other.getProduced();

        overflowed = other.getOverflowed();

        bytes = other.getBytes();
    }

    public long getProduced() {
        return produced;
    }

    public MessageInfo setProduced(long produced) {
        this.produced = produced;
        return this;
    }

    public long getOverflowed() {
        return overflowed;
    }

    public MessageInfo setOverflowed(long overflowed) {
        this.overflowed = overflowed;
        return this;
    }

    public long getBytes() {
        return bytes;
    }

    public MessageInfo setBytes(long bytes) {
        this.bytes = bytes;
        return this;
    }

}
