package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;

public class OsInfo extends BaseEntity<OsInfo> {

    private String name;
    private String arch;
    private String version;
    private int    availableProcessors;
    private double systemLoadAverage;
    private long   processTime;
    private long   totalPhysicalMemory;
    private long   freePhysicalMemory;
    private long   committedVirtualMemory;
    private long   totalSwapSpace;
    private long   freeSwapSpace;

    public OsInfo() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitOs(this);
    }

    @Override
    public void mergeAttributes(OsInfo other) {
        if (other.getName() != null) {
            name = other.getName();
        }

        if (other.getArch() != null) {
            arch = other.getArch();
        }

        if (other.getVersion() != null) {
            version = other.getVersion();
        }

        availableProcessors = other.getAvailableProcessors();

        systemLoadAverage = other.getSystemLoadAverage();

        processTime = other.getProcessTime();

        totalPhysicalMemory = other.getTotalPhysicalMemory();

        freePhysicalMemory = other.getFreePhysicalMemory();

        committedVirtualMemory = other.getCommittedVirtualMemory();

        totalSwapSpace = other.getTotalSwapSpace();

        freeSwapSpace = other.getFreeSwapSpace();
    }

    public String getName() {
        return name;
    }

    public OsInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getArch() {
        return arch;
    }

    public OsInfo setArch(String arch) {
        this.arch = arch;
        return this;
    }

    public String getVersion() {
        return version;
    }

    public OsInfo setVersion(String version) {
        this.version = version;
        return this;
    }

    public int getAvailableProcessors() {
        return availableProcessors;
    }

    public OsInfo setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
        return this;
    }

    public double getSystemLoadAverage() {
        return systemLoadAverage;
    }

    public OsInfo setSystemLoadAverage(double systemLoadAverage) {
        this.systemLoadAverage = systemLoadAverage;
        return this;
    }

    public long getProcessTime() {
        return processTime;
    }

    public OsInfo setProcessTime(long processTime) {
        this.processTime = processTime;
        return this;
    }

    public long getTotalPhysicalMemory() {
        return totalPhysicalMemory;
    }

    public OsInfo setTotalPhysicalMemory(long totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
        return this;
    }

    public long getFreePhysicalMemory() {
        return freePhysicalMemory;
    }

    public OsInfo setFreePhysicalMemory(long freePhysicalMemory) {
        this.freePhysicalMemory = freePhysicalMemory;
        return this;
    }

    public long getCommittedVirtualMemory() {
        return committedVirtualMemory;
    }

    public OsInfo setCommittedVirtualMemory(long committedVirtualMemory) {
        this.committedVirtualMemory = committedVirtualMemory;
        return this;
    }

    public long getTotalSwapSpace() {
        return totalSwapSpace;
    }

    public OsInfo setTotalSwapSpace(long totalSwapSpace) {
        this.totalSwapSpace = totalSwapSpace;
        return this;
    }

    public long getFreeSwapSpace() {
        return freeSwapSpace;
    }

    public OsInfo setFreeSwapSpace(long freeSwapSpace) {
        this.freeSwapSpace = freeSwapSpace;
        return this;
    }

}
