package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;
import cn.com.duiba.cat.status.model.transform.DefaultXmlBuilder;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatusInfo extends BaseEntity<StatusInfo> {

    private final Map<String, Extension>  extensions  = new LinkedHashMap<String, Extension>();
    private final Map<String, CustomInfo> customInfos = new LinkedHashMap<String, CustomInfo>();
    private       Date                    timestamp;
    private       RuntimeInfo             runtime;
    private       OsInfo                  os;
    private       DiskInfo                disk;
    private       MemoryInfo              memory;
    private       ThreadsInfo             thread;
    private       MessageInfo             message;

    public StatusInfo() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitStatus(this);
    }

    public StatusInfo addCustomInfo(CustomInfo customInfo) {
        customInfos.put(customInfo.getKey(), customInfo);
        return this;
    }

    public StatusInfo addExtension(Extension extension) {
        extensions.put(extension.getId(), extension);
        return this;
    }

    public CustomInfo findCustomInfo(String key) {
        return customInfos.get(key);
    }

    public Extension findExtension(String id) {
        return extensions.get(id);
    }

    public CustomInfo findOrCreateCustomInfo(String key) {
        CustomInfo customInfo = customInfos.get(key);

        if (customInfo == null) {
            synchronized (customInfos) {
                customInfo = customInfos.get(key);

                if (customInfo == null) {
                    customInfo = new CustomInfo(key);
                    customInfos.put(key, customInfo);
                }
            }
        }

        return customInfo;
    }

    public Extension findOrCreateExtension(String id) {
        Extension extension = extensions.get(id);

        if (extension == null) {
            synchronized (extensions) {
                extension = extensions.get(id);

                if (extension == null) {
                    extension = new Extension(id);
                    extensions.put(id, extension);
                }
            }
        }

        return extension;
    }

    @Override
    public void mergeAttributes(StatusInfo other) {
        if (other.getTimestamp() != null) {
            timestamp = other.getTimestamp();
        }
    }

    public boolean removeCustomInfo(String key) {
        if (customInfos.containsKey(key)) {
            customInfos.remove(key);
            return true;
        }

        return false;
    }

    public boolean removeExtension(String id) {
        if (extensions.containsKey(id)) {
            extensions.remove(id);
            return true;
        }

        return false;
    }

    @Override
    public String toString() {
        return new DefaultXmlBuilder().buildXml(this);
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public StatusInfo setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public RuntimeInfo getRuntime() {
        return runtime;
    }

    public StatusInfo setRuntime(RuntimeInfo runtime) {
        this.runtime = runtime;
        return this;
    }

    public OsInfo getOs() {
        return os;
    }

    public StatusInfo setOs(OsInfo os) {
        this.os = os;
        return this;
    }

    public DiskInfo getDisk() {
        return disk;
    }

    public StatusInfo setDisk(DiskInfo disk) {
        this.disk = disk;
        return this;
    }

    public MemoryInfo getMemory() {
        return memory;
    }

    public StatusInfo setMemory(MemoryInfo memory) {
        this.memory = memory;
        return this;
    }

    public ThreadsInfo getThread() {
        return thread;
    }

    public StatusInfo setThread(ThreadsInfo thread) {
        this.thread = thread;
        return this;
    }

    public MessageInfo getMessage() {
        return message;
    }

    public StatusInfo setMessage(MessageInfo message) {
        this.message = message;
        return this;
    }

    public Map<String, Extension> getExtensions() {
        return extensions;
    }

    public Map<String, CustomInfo> getCustomInfos() {
        return customInfos;
    }
}
