/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.Event;
import cn.com.duiba.cat.message.Heartbeat;
import cn.com.duiba.cat.message.MessageProducer;
import cn.com.duiba.cat.message.Metric;
import cn.com.duiba.cat.message.Trace;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.DefaultEvent;
import cn.com.duiba.cat.message.internal.DefaultHeartbeat;
import cn.com.duiba.cat.message.internal.DefaultMessageManager;
import cn.com.duiba.cat.message.internal.DefaultMetric;
import cn.com.duiba.cat.message.internal.DefaultTrace;
import cn.com.duiba.cat.message.internal.DefaultTransaction;
import cn.com.duiba.cat.message.internal.MessageIdFactory;
import cn.com.duiba.cat.message.spi.MessageManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageProducer
implements MessageProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageProducer.class);
    private static final String ERROR = "ERROR";
    private static ConcurrentHashMap<Long, ConcurrentHashMap<String, AtomicInteger>> stack = new ConcurrentHashMap();
    private static MessageProducer INSTANCE = new DefaultMessageProducer();
    private MessageManager manager = DefaultMessageManager.getInstance();
    private MessageIdFactory factory = MessageIdFactory.getInstance();

    public static void clearCache() {
        long time = System.currentTimeMillis() / 1000L / 60L - 3L;
        HashSet<Long> removeKeys = new HashSet<Long>();
        for (Long l : stack.keySet()) {
            if (l > time) continue;
            removeKeys.add(l);
        }
        for (Long l : removeKeys) {
            stack.remove(l);
        }
    }

    public static MessageProducer getInstance() {
        return INSTANCE;
    }

    private String buildStackInfo(String message, Throwable cause) {
        StringWriter writer = new StringWriter(2048);
        if (message != null) {
            writer.write(message);
            writer.write(32);
        }
        if (this.recordStackTrace(cause.getClass().getName())) {
            Cat.getManager().getThreadLocalMessageTree().setDiscardPrivate(false);
            cause.printStackTrace(new PrintWriter(writer));
        } else {
            writer.write("The exception with same name will print stack eighty times in one minute, discard exception stack to avoid abnormal performance bottleneck");
        }
        return writer.toString();
    }

    @Override
    public String createMessageId() {
        return this.factory.getNextId();
    }

    @Override
    public String createRpcServerId(String domain) {
        return this.factory.getNextId(domain);
    }

    @Override
    public void logError(String message, Throwable cause) {
        LOGGER.error("fucked, {}", (Object)message, (Object)cause);
        if (this.notExsitCause(cause)) {
            String detailMessage = this.buildStackInfo(message, cause);
            String name = cause.getClass().getName();
            if (cause instanceof Error) {
                this.logEvent("Error", name, ERROR, detailMessage);
            } else if (cause instanceof RuntimeException) {
                this.logEvent("RuntimeException", name, ERROR, detailMessage);
            } else {
                this.logEvent("Exception", name, ERROR, detailMessage);
            }
        }
    }

    @Override
    public void logError(Throwable cause) {
        this.logError(null, cause);
    }

    @Override
    public void logErrorWithCategory(String category, String message, Throwable cause) {
        if (this.notExsitCause(cause)) {
            String detailMessage = this.buildStackInfo(message, cause);
            if (cause instanceof Error) {
                this.logEvent("Error", category, ERROR, detailMessage);
            } else if (cause instanceof RuntimeException) {
                this.logEvent("RuntimeException", category, ERROR, detailMessage);
            } else {
                this.logEvent("Exception", category, ERROR, detailMessage);
            }
        }
    }

    @Override
    public void logErrorWithCategory(String category, Throwable cause) {
        this.logErrorWithCategory(category, null, cause);
    }

    @Override
    public void logEvent(String type, String name) {
        this.logEvent(type, name, "0", null);
    }

    @Override
    public void logEvent(String type, String name, String status, String nameValuePairs) {
        Event event = this.newEvent(type, name);
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            event.addData(nameValuePairs);
        }
        event.setStatus(status);
        event.complete();
    }

    @Override
    public void logHeartbeat(String type, String name, String status, String nameValuePairs) {
        Heartbeat heartbeat = this.newHeartbeat(type, name);
        heartbeat.addData(nameValuePairs);
        heartbeat.setStatus(status);
        heartbeat.complete();
    }

    @Override
    public void logMetric(String name, String status, String nameValuePairs) {
        String type = "";
        Metric metric = this.newMetric(type, name);
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            metric.addData(nameValuePairs);
        }
        metric.setStatus(status);
        metric.complete();
    }

    @Override
    public Event newEvent(String type, String name) {
        if (!this.manager.hasContext()) {
            this.manager.setup();
        }
        return new DefaultEvent(type, name, this.manager);
    }

    @Override
    public Heartbeat newHeartbeat(String type, String name) {
        if (!this.manager.hasContext()) {
            this.manager.setup();
        }
        DefaultHeartbeat heartbeat = new DefaultHeartbeat(type, name, this.manager);
        this.manager.getThreadLocalMessageTree().setDiscardPrivate(false);
        return heartbeat;
    }

    @Override
    public Metric newMetric(String type, String name) {
        if (!this.manager.hasContext()) {
            this.manager.setup();
        }
        DefaultMetric metric = new DefaultMetric(type == null ? "" : type, name, this.manager);
        this.manager.getThreadLocalMessageTree().setDiscardPrivate(false);
        return metric;
    }

    @Override
    public Trace newTrace(String type, String name) {
        if (!this.manager.hasContext()) {
            this.manager.setup();
        }
        return new DefaultTrace(type, name, this.manager);
    }

    @Override
    public Transaction newTransaction(String type, String name) {
        if (!this.manager.hasContext()) {
            this.manager.setup();
        }
        DefaultTransaction transaction = new DefaultTransaction(type, name, this.manager);
        this.manager.start(transaction, false);
        return transaction;
    }

    public Transaction newTransaction(Transaction parent, String type, String name) {
        if (!this.manager.hasContext()) {
            this.manager.setup();
        }
        DefaultTransaction transaction = new DefaultTransaction(type, name, this.manager);
        parent.addChild(transaction);
        transaction.setStandalone(false);
        return transaction;
    }

    private boolean notExsitCause(Throwable e) {
        if (this.manager instanceof DefaultMessageManager) {
            return ((DefaultMessageManager)this.manager).notExsitCause(e);
        }
        return true;
    }

    private boolean recordStackTrace(String exception) {
        try {
            AtomicInteger oldValue;
            AtomicInteger value;
            long minute = System.currentTimeMillis() / 1000L / 60L;
            ConcurrentHashMap<String, AtomicInteger> stack = DefaultMessageProducer.stack.get(minute);
            if (stack == null) {
                stack = new ConcurrentHashMap();
                ConcurrentHashMap<String, AtomicInteger> oldStack = DefaultMessageProducer.stack.putIfAbsent(minute, stack);
                if (oldStack != null) {
                    stack = oldStack;
                }
            }
            if ((value = stack.get(exception)) == null && (oldValue = stack.putIfAbsent(exception, value = new AtomicInteger(0))) != null) {
                value = oldValue;
            }
            return value.incrementAndGet() <= 80;
        }
        catch (Exception e) {
            return true;
        }
    }
}

