/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.queue;

import cn.com.duiba.cat.message.spi.MessageQueue;
import cn.com.duiba.cat.message.spi.MessageTree;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class PriorityMessageQueue
implements MessageQueue {
    private BlockingQueue<MessageTree> highQueue;
    private BlockingQueue<MessageTree> normalQueue;

    public PriorityMessageQueue(int size) {
        this.highQueue = new ArrayBlockingQueue<MessageTree>(size / 2);
        this.normalQueue = new ArrayBlockingQueue<MessageTree>(size);
    }

    @Override
    public boolean offer(MessageTree tree) {
        if (tree.canDiscard()) {
            return this.normalQueue.offer(tree);
        }
        return this.highQueue.offer(tree);
    }

    @Override
    public MessageTree peek() {
        MessageTree tree = (MessageTree)this.highQueue.peek();
        if (tree == null) {
            tree = (MessageTree)this.normalQueue.peek();
        }
        return tree;
    }

    @Override
    public MessageTree poll() {
        MessageTree tree = (MessageTree)this.highQueue.poll();
        if (tree == null) {
            try {
                tree = this.normalQueue.poll(5L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return tree;
    }

    @Override
    public int size() {
        return this.normalQueue.size() + this.highQueue.size();
    }
}

