/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;
import cn.com.duiba.cat.status.model.entity.CustomInfo;
import cn.com.duiba.cat.status.model.entity.DiskInfo;
import cn.com.duiba.cat.status.model.entity.Extension;
import cn.com.duiba.cat.status.model.entity.MemoryInfo;
import cn.com.duiba.cat.status.model.entity.MessageInfo;
import cn.com.duiba.cat.status.model.entity.OsInfo;
import cn.com.duiba.cat.status.model.entity.RuntimeInfo;
import cn.com.duiba.cat.status.model.entity.ThreadsInfo;
import cn.com.duiba.cat.status.model.transform.DefaultXmlBuilder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatusInfo
extends BaseEntity<StatusInfo> {
    private final Map<String, Extension> extensions = new LinkedHashMap<String, Extension>();
    private final Map<String, CustomInfo> customInfos = new LinkedHashMap<String, CustomInfo>();
    private Date timestamp;
    private RuntimeInfo runtime;
    private OsInfo os;
    private DiskInfo disk;
    private MemoryInfo memory;
    private ThreadsInfo thread;
    private MessageInfo message;

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitStatus(this);
    }

    public StatusInfo addCustomInfo(CustomInfo customInfo) {
        this.customInfos.put(customInfo.getKey(), customInfo);
        return this;
    }

    public StatusInfo addExtension(Extension extension) {
        this.extensions.put(extension.getId(), extension);
        return this;
    }

    public CustomInfo findCustomInfo(String key) {
        return this.customInfos.get(key);
    }

    public Extension findExtension(String id) {
        return this.extensions.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomInfo findOrCreateCustomInfo(String key) {
        CustomInfo customInfo = this.customInfos.get(key);
        if (customInfo == null) {
            Map<String, CustomInfo> map = this.customInfos;
            synchronized (map) {
                customInfo = this.customInfos.get(key);
                if (customInfo == null) {
                    customInfo = new CustomInfo(key);
                    this.customInfos.put(key, customInfo);
                }
            }
        }
        return customInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension findOrCreateExtension(String id) {
        Extension extension = this.extensions.get(id);
        if (extension == null) {
            Map<String, Extension> map = this.extensions;
            synchronized (map) {
                extension = this.extensions.get(id);
                if (extension == null) {
                    extension = new Extension(id);
                    this.extensions.put(id, extension);
                }
            }
        }
        return extension;
    }

    @Override
    public void mergeAttributes(StatusInfo other) {
        if (other.getTimestamp() != null) {
            this.timestamp = other.getTimestamp();
        }
    }

    public boolean removeCustomInfo(String key) {
        if (this.customInfos.containsKey(key)) {
            this.customInfos.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeExtension(String id) {
        if (this.extensions.containsKey(id)) {
            this.extensions.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new DefaultXmlBuilder().buildXml(this);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public StatusInfo setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public RuntimeInfo getRuntime() {
        return this.runtime;
    }

    public StatusInfo setRuntime(RuntimeInfo runtime) {
        this.runtime = runtime;
        return this;
    }

    public OsInfo getOs() {
        return this.os;
    }

    public StatusInfo setOs(OsInfo os) {
        this.os = os;
        return this;
    }

    public DiskInfo getDisk() {
        return this.disk;
    }

    public StatusInfo setDisk(DiskInfo disk) {
        this.disk = disk;
        return this;
    }

    public MemoryInfo getMemory() {
        return this.memory;
    }

    public StatusInfo setMemory(MemoryInfo memory) {
        this.memory = memory;
        return this;
    }

    public ThreadsInfo getThread() {
        return this.thread;
    }

    public StatusInfo setThread(ThreadsInfo thread) {
        this.thread = thread;
        return this;
    }

    public MessageInfo getMessage() {
        return this.message;
    }

    public StatusInfo setMessage(MessageInfo message) {
        this.message = message;
        return this;
    }

    public Map<String, Extension> getExtensions() {
        return this.extensions;
    }

    public Map<String, CustomInfo> getCustomInfos() {
        return this.customInfos;
    }
}

