/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.util;

import java.util.Arrays;
import java.util.Collection;

public class Joiners {
    public static StringJoiner by(final char delimiter) {
        return new StringJoiner(){

            @Override
            protected void appendDelimiter(StringBuilder sb) {
                sb.append(delimiter);
            }
        };
    }

    public static StringJoiner by(final String delimiter) {
        return new StringJoiner(){

            @Override
            protected void appendDelimiter(StringBuilder sb) {
                sb.append(delimiter);
            }
        };
    }

    public static abstract class StringJoiner {
        private boolean prefixDelimiter;

        protected abstract void appendDelimiter(StringBuilder var1);

        public String join(Collection<String> list) {
            return this.join(list, null);
        }

        public <T> String join(Collection<T> list, IBuilder<T> builder) {
            if (list == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            this.join(sb, list, builder);
            return sb.toString();
        }

        public String join(String ... array) {
            return this.join(Arrays.asList(array), null);
        }

        public <T> String join(IBuilder<T> builder, T ... array) {
            return this.join(Arrays.asList(array), builder);
        }

        public <T> void join(StringBuilder sb, Collection<T> list, IBuilder<T> builder) {
            boolean first = true;
            if (list != null) {
                for (T item : list) {
                    if (first) {
                        first = false;
                        if (this.prefixDelimiter) {
                            this.appendDelimiter(sb);
                        }
                    } else {
                        this.appendDelimiter(sb);
                    }
                    if (builder == null) {
                        sb.append(item);
                        continue;
                    }
                    sb.append(builder.asString(item));
                }
            }
        }

        public StringJoiner prefixDelimiter() {
            this.prefixDelimiter = true;
            return this;
        }
    }

    public static interface IBuilder<T> {
        public String asString(T var1);
    }
}

