package cn.com.duiba.cdn.service.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

/**
 * Created by hong
 * time 2022/6/9.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CdnObjectDto implements Serializable, Closeable {

    /**
     * Object key (name)
     */
    private String key;

    /**
     * 对象类型
     */
    private String      contentType;

    /**
     * 对象流
     */
    private InputStream inputStream;

    @Override
    public void close() throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
    }
}
