package cn.com.duiba.cdn.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cdn.service.api.Exception.MinioException;
import cn.com.duiba.cdn.service.api.dto.CdnObjectDto;
import cn.com.duiba.cdn.service.api.dto.CdnUploadResult;
import cn.com.duiba.cdn.service.api.dto.UploadResult;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

/**
 * Created by hong
 * time 2022/6/9.
 */
@AdvancedFeignClient
public interface RemoteCdnService {
    /**
     * 传入Consumer进行流式处理
     *
     * @param consumer   在consumer内部操作inputStream,inputStream无需关闭
     * @param objectName objectName
     */
    void doWithInputStream(Consumer<InputStream> consumer, String objectName);

    /**
     * 获取文件流进行处理
     * @param objectName objectName
     */
    CdnObjectDto getCdnObject(String objectName) throws MinioException;

    /**
     * 上传文件
     * @param multipartFile
     * @param path
     * @param noTime
     * @return
     * @throws Exception
     */
    CdnUploadResult upload(File file, String path, Integer noTime) throws Exception;

}
