package cn.com.duiba.galaxy.api.model.dto.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 自定义配置json
 *
 * @author fangxiaorun
 * @date 2022/10/18
 */
@Getter
@Setter
public class CustomConfigJsonDto implements Serializable {

    private static final long serialVersionUID = -4012514007572651329L;
    /**
     * 名称
     */
    private String name;
    /**
     * 变量
     */
    private String variable;
    /**
     * 校验
     */
    private String valid;
    /**
     * 类型
     */
    private String type;
    /**
     * 配置类型(前端配置项，后端配置项，运营配置项)
     */
    private Integer configType;
    /**
     * 提示
     */
    private String tips;
    /**
     * 值
     */
    private String value;
    /**
     * 描述(type为JSONArray时必填)
     */
    private String desc;
    /**
     * 只读 0 非必读， 1 必读
     */
    private Integer readOnly;
}
