package cn.com.duiba.galaxy.api.model.dto.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 奖项json
 *
 * @author fangxiaorun
 * @date 2022/10/18
 */
@Getter
@Setter
public class OptionJsonDto implements Serializable {

    private static final long serialVersionUID = 2570554630986332102L;


    /**
     * 奖项id
     */
    private String id;
    /**
     * 奖项名称
     */
    private String name;
    /**
     * 奖项类型
     */
    private Integer type;
    /**
     * 商品id
     */
    private String itemId;
    /**
     * 图标
     */
    private String icon;

    /**
     * 图标
     */
    private String icon2;


    /**
     * 总库存
     */
    private Long totalStock;

    /**
     * 概率
     */
    private String rate;
    /**
     * 用户中奖限制次数
     */
    private Long userLimit;

    /**
     * 用户中奖限制类型(日，周，月，永久)
     */
    private Integer userLimitType;

    /**
     * 发奖限制
     */
    private Long awardLimit;
    /**
     * 发奖限制类型(日，周，月，永久)
     */
    private Integer awardLimitType;

    /**
     * 奖品id
     */
    private String prizeId;

    /**
     * 奖项位置
     */
    private Integer pos;

    /**
     * 已使用库存
     */
    private Long usedStock;

    /**
     * 保底次数(针对用户维度，产生多少次抽奖行为才会中奖)
     */
    private Long atleastTimes;

    /**
     * 是否在首页展示 0 不展示 ， 1展示
     */
    private Integer showIndexType;

    /**
     * 单次发放个数(仅道具)
     */
    private Long sendCount;

    /**
     * 是否允许多奖项
     */
    private boolean multipleOption;

    /**
     * 变化类型
     */
    private Integer changeType;
}
