package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 出奖策略json参数
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class StrategyJsonParam implements Serializable {

    private static final long serialVersionUID = 6807063861433366435L;

    /**
     * 发奖规则id
     */
    private String id;
    /**
     * 发奖规则类型（1概率出奖，2百分百中奖）
     */
    private Integer type;
    /**
     * 发奖规则名称
     */
    private String name;
    /**
     * 分层是否启用 true 启用
     */
    private boolean layeredEnable;
    /**
     * 分层类型 1区分奖池，2区分概率
     */
    private Integer layeredType;

    /**
     * 变化类型
     *
     * @see ChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 奖项列表
     */
    private List<OptionJsonParam> options;

    /**
     * 多个奖项限制
     */
    private MultipleOptionLimitJsonParam multipleOptionLimit;

    /**
     * 分层规则
     */
    private List<LayeredRuleJsonParam> layeredRules;

    /**
     * 分层身份
     */
    private String layeredIdentity;
}
