package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.ProjectDto;
import cn.com.duiba.galaxy.api.model.param.ProjectCreateOrUpdateParam;


/**
 * "项目"远程服务
 *
 * @author fangxiaorun
 * @date 2022/10/11
 */
@AdvancedFeignClient
public interface RemoteProjectBackendService {

    /**
     * 创建"模版活动"
     * 注：仅供积分商城使用
     *
     * @param param 参数
     * @return {@link Long}
     * @throws BizException 业务异常
     */
    Long createForMall(ProjectCreateOrUpdateParam param) throws BizException;

    /**
     * 更新"模版活动"
     * 注：仅供积分商城使用
     *
     * @param param 参数
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean updateForMall(ProjectCreateOrUpdateParam param) throws BizException;

    /**
     * 通过id获取项目
     *
     * @param id id
     * @return {@link ProjectDto}
     */
    ProjectDto getById(Long id) throws BizException;

    /**
     * 更新状态
     * <p>
     * INIT(0, "待编辑"),
     * WAIT_PUBLISH(1, "待发布"),
     * WAIT_ON_LINE(2, "已发布待上线"),
     * ON_LINE(3, "已上线"),
     * OFF_LINE(4, "已下线"),
     *
     * @param projectId 项目id
     * @param state     状态
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean updateState(Long projectId, Integer state) throws BizException;
}
