package cn.com.duiba.galaxy.api.model.param;

import cn.com.duiba.galaxy.api.model.param.jsonfield.BaseAttributesJsonParam;
import cn.com.duiba.galaxy.api.model.param.jsonfield.PlayAttributesJsonParam;
import cn.com.duiba.galaxy.api.model.param.jsonfield.ViewAttributesJsonParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 项目创建或更新参数
 * 注：仅供积分商城使用
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class ProjectNewOrUpdateParam implements Serializable {

    private static final long serialVersionUID = 7761141344880451353L;

    /**
     * appId
     */
    @NotBlank
    private Long appId;

    /**
     * 模版ID
     */
    @NotNull(groups = Create.class)
    private Long templateId;

    /**
     * 项目id
     */
    @NotNull(groups = Update.class)
    private Long id;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 开始时间
     */
    @NotNull
    private Date startTime;

    /**
     * 结束时间
     */
    @NotNull
    private Date endTime;

    /**
     * 玩法属性
     */
    @NotNull
    private PlayAttributesJsonParam playAttributes;

    /**
     * 界面属性
     */
    @NotNull
    private ViewAttributesJsonParam viewAttributes;

    /**
     * 基础属性
     */
    @NotNull
    private BaseAttributesJsonParam baseAttributes;

    /**
     * 按钮类型 1保存(仅针对活动未上线时)，2保存并发布
     */
    private Integer buttonType;

    /**
     * 是否是正式项目 0非正式,1正式
     */
    @NotNull
    private Integer prod;

    /**
     * 原型id
     */
    @NotNull
    private Long prototypeId;

    /**
     * 原型类型  1定制，2模板
     */
    @NotNull
    private Integer prototypeType;

    /**
     * 来源 0活动平台,1积分商城
     */
    @NotNull
    private Integer source;

    /**
     * 状态
     * INIT(0, "待编辑"),
     * WAIT_PUBLISH(1, "待发布"),
     * WAIT_ON_LINE(2, "已发布待上线"),
     * ON_LINE(3, "已上线"),
     * OFF_LINE(4, "未上线"),
     */
    @NotNull
    private Integer state;

    /**
     * 模版活动分组校验标识：创建
     */
    public interface Create {
    }

    /**
     * 模版活动分组校验标识：更新
     */
    public interface Update {
    }
}