package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * "订单结果回调"远程服务
 *
 * @author fangxiaorun
 * @date 2022/10/11
 */
@AdvancedFeignClient
public interface RemoteOrderBackendService {

    /**
     * 同步订单状态
     * @param projectNum 星速台订单号
     * @param orderNum   兑吧订单号
     * @param success    是否成功
     * @param msg        消息
     * @throws BizException
     */
    void orderNotify(String projectNum,
                     String orderNum,
                     boolean success,
                     String msg) throws BizException;
}
