package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.TemplateDto;

import java.util.List;


/**
 * "模板"远程服务
 * 注：仅供积分商城调用
 *
 * @author fangxiaorun
 * @date 2022/10/11
 */
@AdvancedFeignClient
public interface RemoteTemplateBackendService {
    /**
     * 通过appid查询,已同步的模版
     *
     * @param appId 应用id
     * @return {@link List}<{@link TemplateDto}>
     */
    List<TemplateDto> listByAppId(Long appId) throws BizException;

    /**
     * 通过原型id获取模版
     *
     * @param prototypeId 原型id
     * @return {@link TemplateDto}
     * @throws BizException 业务异常
     */
    TemplateDto getByPrototypeId(Long prototypeId) throws BizException;

    /**
     * 通过id获取模版
     *
     * @param id id
     * @return {@link TemplateDto}
     * @throws BizException 业务异常
     */
    TemplateDto getById(Long id) throws BizException;
}
