package cn.com.duiba.galaxy.api.model.dto;

import cn.com.duiba.galaxy.api.model.dto.jsonfield.BaseAttributesJsonDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.PlayAttributesJsonDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.ShareAttributesJsonDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.ViewAttributesJsonDto;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 项目DTO
 *
 * @author fangxiaorun
 * @date 2022/10/18
 */
@Getter
@Setter
public class ProjectDto implements Serializable {

    private static final long serialVersionUID = -44961641526572499L;

    /**
     * id
     */
    private Long id;
    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 原型id
     */
    private Long prototypeId;
    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 是否正式
     */
    private Integer prod;

    /**
     * 状态
     */
    private Integer state;

    /**
     * 来源
     */
    private Integer source;

    /**
     * 玩法属性
     */
    private PlayAttributesJsonDto playAttributes;

    /**
     * 视觉属性
     */
    private ViewAttributesJsonDto viewAttributes;

    /**
     * 基础属性
     */
    private BaseAttributesJsonDto baseAttributes;

    /**
     * 分享属性
     */
    private ShareAttributesJsonDto shareAttributes;

    /**
     * sps
     */
    private List<SpDto> sps;
    /**
     * 修改时间
     */
    private Date gmtModified;
}
