package cn.com.duiba.galaxy.api.model.dto.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 出奖策略json
 *
 * @author fangxiaorun
 * @date 2022/10/18
 */
@Getter
@Setter
public class StrategyJsonDto implements Serializable {

    private static final long serialVersionUID = -4700839929749396435L;
    /**
     * 发奖规则id
     */
    private String id;
    /**
     * 发奖规则类型（1概率出奖，2百分百中奖）
     */
    private Integer type;
    /**
     * 规则是否启用 true 启用
     */
    private Boolean strategyEnable;
    /**
     * 发奖规则名称
     */
    private String name;
    /**
     * 分层是否启用 true 启用
     */
    private boolean layeredEnable;
    /**
     * 分层类型 1区分奖池，2区分概率
     */
    private Integer layeredType;

    /**
     * 奖项列表
     */
    private List<OptionJsonDto> options;

    /**
     * 多个奖项限制
     */
    private MultipleOptionLimitJsonDto multipleOptionLimit;

    /**
     * 分层规则
     */
    private List<LayeredRuleJsonDto> layeredRules;

    /**
     * 分层身份
     */
    private String layeredIdentity;



    /**
     * 保底奖池是否开启
     */
    private boolean bottomPrizeEnable;


    /**
     * 保底奖池奖品
     */
    private List<OptionJsonDto> bottomOptions;
}
