package cn.com.duiba.galaxy.console.controller;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

/**
 * @author zhangdaqing
 * @Date 2022/11/15 16:15
 *
 * http://coolaf.com/tool/chattest 在线测试工具
 **/
@Component
@Slf4j
@ServerEndpoint(value = "/link/{userId}")
public class ConsoleWebSocketController {
    private String userId;

    // 连接时执行
    @OnOpen
    public void onOpen(@PathParam("userId") String userId) {
        this.userId = userId;
        log.info("新连接：{}", userId);
    }

    // 关闭时执行
    @OnClose
    public void onClose() {
        log.info("连接：{} 关闭", this.userId);
    }

    // 收到消息时执行
    @OnMessage
    public void onMessage(String message) {
        log.info("收到用户{}的消息{}", this.userId, message);
    }

    // 连接错误时执行
    @OnError
    public void onError(Throwable error) {
        log.info("用户userId为：{}的连接发送错误", this.userId);
        error.printStackTrace();
    }

}
