package cn.com.duiba.galaxy.console.controller;

import cn.com.duiba.galaxy.console.manager.ItemManager;
import cn.com.duiba.galaxy.console.model.param.item.ItemListQueryParam;
import cn.com.duiba.galaxy.console.model.vo.item.ItemVo;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 商品管理
 *
 * @author zhangdaqing
 * @Date 2022/10/20 14:53
 **/
@RestController
@RequestMapping("item")
public class ItemController {

    @Resource
    private ItemManager itemManager;

    /**
     * 列表商品
     *
     * @param param 参数
     * @return {@link JsonResult}<{@link List}<{@link ItemVo}>>
     */
    @PostMapping("listItem")
    public JsonResult<List<ItemVo>> listItem(@Validated @RequestBody ItemListQueryParam param) {

        // todo 待适配
        List<ItemVo> itemVos = itemManager.listItem(param);

        return JsonResult.success(itemVos);
    }
}
