package cn.com.duiba.galaxy.console.controller;

import cn.com.duiba.galaxy.console.manager.SsoExtManager;
import cn.com.duiba.galaxy.console.model.vo.admin.AdminVo;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * SSO扩展接口
 *
 * @author fangxiaorun
 * @date 2022/11/05
 */
@RestController
@RequestMapping("/ssoExt")
public class SsoExtController {

    @Autowired
    private SsoExtManager ssoExtManager;

    /**
     * 获取管理信息
     *
     * @return {@link JsonResult}<{@link AdminVo}>
     */
    @GetMapping("getAdminInfo")
    public JsonResult<AdminVo> getAdminInfo() {
        return JsonResult.success(ssoExtManager.getAdminInfo());
    }
}
