package cn.com.duiba.galaxy.console.controller;


import cn.com.duiba.galaxy.console.manager.TemplateBackendManager;
import cn.com.duiba.galaxy.console.model.param.template.TemplatePageQueryParam;
import cn.com.duiba.galaxy.console.model.param.template.TemplateSaveParam;
import cn.com.duiba.galaxy.console.model.param.template.TemplateSyncParam;
import cn.com.duiba.galaxy.console.model.vo.PageList;
import cn.com.duiba.galaxy.console.model.vo.template.TemplateVo;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 模板管理
 *
 * @author fangxiaorun
 * @since 2022/09/30
 */
@RestController
@RequestMapping("template")
public class TemplateBackendController {

    @Autowired
    private TemplateBackendManager templateBackendManager;

    /**
     * 通过模版id获取模版信息
     *
     * @param id 模版ID
     * @return {@link JsonResult}<{@link TemplateVo}>
     */
    @GetMapping("getById")
    public JsonResult<TemplateVo> getById(Long id) {
        return JsonResult.success(templateBackendManager.getById(id));
    }

    /**
     * 分页获取模版列表
     *
     * @param param 参数
     * @return {@link JsonResult}<{@link PageList}<{@link TemplateVo}>>
     */
    @GetMapping("list")
    public JsonResult<PageList<TemplateVo>> list(TemplatePageQueryParam param) {
        return JsonResult.success(templateBackendManager.list(param));
    }

    /**
     * 保存模版
     *
     * @param param 参数
     * @return {@link JsonResult}<{@link Boolean}>
     */
    @PostMapping("save")
    public JsonResult<Boolean> save(@RequestBody @Validated TemplateSaveParam param) {
        return JsonResult.success(templateBackendManager.save(param));
    }

    /**
     * 同步模版
     *
     * @param param 参数
     * @return {@link JsonResult}<{@link Boolean}>
     */
    @PostMapping("sync")
    public JsonResult<Boolean> sync(@RequestBody @Validated TemplateSyncParam param) {
        return JsonResult.success(templateBackendManager.sync(param));
    }
}
