package cn.com.duiba.galaxy.console.controller;

import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.devops.web.api.RemoteAmiyaProjectService;
import cn.com.duiba.galaxy.basic.service.ProjectService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.basic.service.SpService;
import cn.com.duiba.galaxy.console.enums.EnvironmentTypeEnum;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.console.manager.PrototypeManager;
import cn.com.duiba.galaxy.console.model.param.prototype.CrossPushPrototypeParam;
import cn.com.duiba.galaxy.core.activity.ClientBizProjectConfigMap;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * 临时api文档
 *
 * @author zhangdaqing
 * @Date 2022/10/14 10:03
 **/
@RestController
@RequestMapping("/common")
public class YapiTest {

    @Resource
    private RemoteAmiyaProjectService remoteAmiyaProjectService;

    @Resource
    private ProjectManager projectManager;

    @Autowired
    private ProjectService projectService;


    @Autowired
    private PrototypeService prototypeService;


    @Resource
    private PrototypeManager prototypeManager;

    @Autowired
    protected SpService spService;
    @Resource
    private RemoteAppService remoteAppService;

    @Autowired
    protected ClientBizProjectConfigMap projectConfigMap;



    /**
     * 跨域推送原型
     *
     * @param param   参数
     * @param request 请求
     * @return {@link JsonResult}<{@link Boolean}>
     */
    @PostMapping("pushPrototype")
    @CsrfOff
    public JsonResult<Boolean> pushPrototype(@Validated @RequestBody CrossPushPrototypeParam param
            , HttpServletRequest request) {
        EnvironmentTypeEnum environmentTypeEnum = EnvironmentTypeEnum.getEnvironmentTypeEnumByCode(param.getEnvironment());
        String targetUri = StringUtils.replace(request.getRequestURI(), "pushPrototype", "receiveAndSavePrototype");
        String url = String.format("http://galaxy.%s.com.cn%s", environmentTypeEnum.getDesc(), targetUri);
        param.setUrl(url);
        prototypeManager.pushPrototype(param);
        return JsonResult.success();
    }

}
