package cn.com.duiba.galaxy.console.enums;


import lombok.Getter;

/**
 * 自定义配置变量类型枚举
 *
 * @author zhangdaqing
 * @date 2022/10/17
 */
@Getter
public enum CustomConfigVariableTypeEnum {
    STRING(1, "字符串", null),
    INTEGER(2, "整数型", "^[-+]?\\d+$"),
    NUMBER(3, "数值(包括整型/浮点型)", "^[-+]?(\\d*\\.?\\d+)$"),
    DATETIME(4, "日期(时间戳)", "^\\d+$"),
    JSON(5, "JSON", null),
    COMPLEX(6, "图片", null),

    ;
    private Integer code;
    private String desc;
    private String regex;


    CustomConfigVariableTypeEnum(Integer code, String desc, String regex) {
        this.code = code;
        this.desc = desc;
        this.regex = regex;
    }


}
