package cn.com.duiba.galaxy.console.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;


/**
 * 环境类型枚举
 *
 * @author zhangdaqing
 * @date 2022/11/12
 */
@Getter
public enum EnvironmentTypeEnum {
    DEV(1, "duibadev"),
    TEST(2, "duibatest"),
    PROD(3, "duiba"),
    ;


    public static EnvironmentTypeEnum getEnvironmentTypeEnumByCode(Integer code) {
        Optional<EnvironmentTypeEnum> any = Arrays.stream(values()).filter(u -> Objects.equals(u.getCode(), code)).findAny();
        return any.orElse(DEV);
    }

    EnvironmentTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;
}
