package cn.com.duiba.galaxy.console.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 身份类型枚举
 *
 * @author zhangdaqing
 * @Date 2022/10/26 13:49
 **/
@Getter
public enum IdentityTypeEnum {
    MEMBER_LEVEL(1, "会员等级"),
    USER_TAG(2, "用户标签"),

    ;

    IdentityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static IdentityTypeEnum getIdentityTypeEnumByCode(Integer code) {
        Optional<IdentityTypeEnum> any = Arrays.stream(values()).filter(u -> u.getCode().equals(code)).findAny();
        return any.orElse(null);
    }

    private Integer code;

    private String desc;


}
