package cn.com.duiba.galaxy.console.enums;


import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.message.SystemModuleEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * 管理后台模块错误枚举
 *
 * @author fangxiaorun
 * @date 2022/09/28
 */
public enum PlatformConsoleErrorEnum implements BizError {
    /*************************** 通用错误码 ***************************/
    SYSTEM_ERROR("101", "网络繁忙，请稍后重试！"),
    PARAM_ERROR("102", "参数错误"),
    FILE_NULL_ERROR("103", "文件为空"),
    FILE_TYPE_NULL_ERROR("104", "文件类型为空"),
    FILE_ILLEGAL_FORMAT_ERROR("105", "文件格式不支持"),
    FILE_UNKNOWN_ERROR("106", "发生未知异常，文件上传失败"),
    FILE_SIZE_LIMIT("107", "文件大小超过限制"),
    CONFIG_CHECK_ERROR("108", "配置检查不通过"),
    SERVICE_UNKNOWN_ERROR("109", "服务内部业务异常，请查看系统日志！"),
    SSO_LOGIN_VERIFY_FAIL("110", "SSO登录验证失败"),
    THE_EMPLOYEE_HAS_LEFT("111", "员工已离职"),
    DOMIAN_NOT_FOUND("112", "Domian not found"),

    /*************************** 原型相关错误码 ***************************/
    PROTOTYPE_NOT_FOUND("200", "原型不存在"),
    PROTOTYPE_NOT_NEW("201", "原型已被其他人修改，刷新后再提交"),
    PROTOTYPE_NOT_ENABLED("202", "原型未启用"),
    PROTOTYPE_NAME_REPEAT("203", "原型名称已被使用"),
    PROTOTYPE_TYPE_NOT_EXIST("204", "原型类型不存在"),
    JAVA_CODE_ERROR("205", "后端代码格式错误"),
    DAYAN_NUL_ERROR("206", "关联大雁必填"),
    PLAY_WAY_TYPE_ILLEGAL("207", "玩法选型不存在"),
    UPDATE_ERROR("208", "原型更新失败"),
    BUILD_ERROR("209", "原型编译失败"),

    /*************************** 模版相关错误码 ***************************/
    TEMPLATE_TYPE_NOT_FOUND("300", "模版类型不存在"),
    PROTOTYPE_HAS_BEEN_ASSOCIATED("301", "该原型已存在关联模版"),
    PROTOTYPE_NOT_MATCH("302", "原型类型不匹配"),
    TEMPLATE_NOT_FOUND("303", "模版不存在"),
    INVALID_CHANGE("304", "无效状态变更"),
    ENUM_NOT_FOUND("305", "枚举类不存在"),
    TEMPLATE_PROTOTYPE_NOT_FOUND("306", "模版关联原型不存在"),
    SKIN_NOT_FOUND("307", "原型皮肤配置缺失"),
    GET_ENUM_ERROR("308", "获取枚举类异常"),
    INVALID_APP("309", "同步APP未检索到"),
    NO_AUTH_TEMPLATE("310", "当前应用无授权模版"),

    /*************************** Project相关错误码 ***************************/
    NULL_PROJECT("401", "项目不存在"),
    NEW_PROJECT_ERROR("402", "项目创建失败"),
    INVALID_TYPE("403", "无效配置类型"),
    NOT_DIRECTED_APP("404", "请先定向app"),
    END_TIME_ERROR("405", "活动结束时间不得小于当前时间"),
    NOT_ALLOW_SAVE("406", "该状态不能执行保存"),
    STATE_CHANGE_ERROR("407", "状态变更失败"),
    APP_NOT_FOUNT("408", "app 不存在"),
    NOT_ALLOW_UPDATE_APP("409", "项目存在关联奖品不能修改appId"),
    NOT_NEWEST_PROJECT("410", "项目已被修改,刷新后再试"),
    UPDATE_PROJECT_ERROR("411", "项目更新失败"),

    ;


    /**
     * 自定义编码
     */
    private final String nodeCode;

    /**
     * 描述
     */
    private String desc;

    PlatformConsoleErrorEnum(String nodeCode, String desc) {
        this.nodeCode = nodeCode;
        this.desc = desc;
    }

    /**
     * 获取场景类型
     *
     * @return {@link SystemModuleEnum}
     */
    @Override
    public SystemModuleEnum getBizScene() {
        return SystemModuleEnum.PLATFORM_CONSOLE;
    }

    /**
     * 获取自定义编码（错误码通过方法{@link BizError#getCode()}获取）
     *
     * @return {@link String}
     */
    @Override
    public String getNodeCode() {
        return nodeCode;
    }

    /**
     * 获取描述信息
     *
     * @return {@link String}
     */
    @Override
    public String getDesc() {
        return desc;
    }

    /**
     * 对指定错误类型修改描述
     *
     * @return {@link PlatformConsoleErrorEnum}
     */
    public BizError setDesc(String errorMsg) {
        if (StringUtils.isNotEmpty(errorMsg)) {
            this.desc = errorMsg;
        }
        return this;
    }

}