package cn.com.duiba.galaxy.console.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 活动选择
 *
 * @author zhangdaqing
 * @Date 2022/9/28 09:40
 * @desc 活动选型
 **/
@Getter
public enum PlaywayTypeEnum {
    JOIN_PLAY(1, "参与玩法"),
    ASSIST_PLAY(2, "助力玩法"),
    LUCKY_CODE_PLAY(3, "幸运码玩法"),
    SCORING(4, "计分玩法"),
    INVITE_PLAY(5, "邀请玩法"),
    YANGCHENG_PLAY(6, "养成玩法"),
    ;

    public static PlaywayTypeEnum getPlaywayTypeEnumByCode(Integer code) {
        Optional<PlaywayTypeEnum> first = Arrays.stream(values()).filter(u -> u.getCode().equals(code)).findFirst();
        return first.orElse(null);
    }


    PlaywayTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;
}
