package cn.com.duiba.galaxy.console.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * 原型状态枚举
 *
 * @author fangxiaorun
 * @date 2022/09/30
 */
@Getter
@AllArgsConstructor
public enum PrototypeStateEnum {
    /**
     * 待编辑
     */
    TO_EDIT(0, "待编辑"),
    /**
     * 未启用
     */
    NOT_ENABLED(1, "未启用"),
    /**
     * 已启用
     */
    ENABLED(2, "已启用"),
    ;

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;
}
