package cn.com.duiba.galaxy.console.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;


/**
 * 模版同步状态枚举
 *
 * @author fangxiaorun
 * @date 2022/09/30
 */
@Getter
@AllArgsConstructor
public enum TemplateSyncStateEnum {

    /**
     * 初始状态（未同步）
     */
    INIT(0, "初始状态（未同步）"),

    /**
     * 局部同步
     */
    LOCAL_SYNC(1, "局部同步"),

    /**
     * 全量同步
     */
    FULL_SYNC(2, "全量同步");

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;

    /**
     * 根据类型码获取枚举对象
     *
     * @param type 类型
     * @return {@link TemplateSyncStateEnum}
     */
    public static TemplateSyncStateEnum valueOfType(Integer type) {
        return Arrays.stream(TemplateSyncStateEnum.values()).filter(obj -> Objects.equals(obj.code, type)).findFirst().orElse(null);
    }
}
