package cn.com.duiba.galaxy.console.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;


/**
 * 活动类型枚举
 *
 * @author fangxiaorun
 * @date 2022/09/30
 */
@Getter
@AllArgsConstructor
public enum TemplateTypeEnum {

    /**
     * 裂变活动（老带新、分享助力、邀约有礼等）
     */
    FISSION(1, "裂变活动"),

    /**
     * 拉新活动（抽奖大转盘、刮刮卡、摇奖机等）
     */
    INVITE_NEW(2, "拉新活动"),

    /**
     * 促活活动（消消乐、大冒险、环游记、签到、答题等）
     */
    PROMOTE_ACTIVE(3, "促活活动"),

    /**
     * 转换活动（秒杀、多件多折、完成任务领奖等）
     */
    CONVERSION(4, "转化活动"),

    /**
     * 工具活动（如报名、问卷等）
     */
    TOOL(5, "工具活动");

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;

    /**
     * 根据类型码获取枚举对象
     *
     * @param type 类型
     * @return {@link TemplateTypeEnum}
     */
    public static TemplateTypeEnum valueOfType(Integer type) {
        return Arrays.stream(TemplateTypeEnum.values()).filter(obj -> Objects.equals(obj.code, type)).findFirst().orElse(null);
    }
}
