package cn.com.duiba.galaxy.console.manager;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.adapter.base.dto.UpdateStockDto;
import cn.com.duiba.galaxy.basic.model.entity.OptionEntity;
import cn.com.duiba.galaxy.console.model.param.OperationalOptionParam;

import java.util.List;

/**
 * Created by hong
 * time 2022/10/29.
 */
public interface OptionManager {

    /**
     * 操作奖项
     */
    Boolean operationalOption(OperationalOptionParam param);

    /**
     * 批处理操作奖项
     *
     * @param operationalOptionParamList 操作奖项参数列表
     * @param updateStockDtos
     * @return {@link Boolean}
     */
    Boolean batchOperationalOption(Long appId, Long projectId, List<OperationalOptionParam> operationalOptionParamList, List<UpdateStockDto> updateStockDtos) throws BizException;


    List<OptionEntity> listOptionByRuIds(Long projectId, List<String> ruIds);

    Boolean batchDelOptions(Long projectId, List<OptionEntity> entities);


    List<OptionEntity> listAllOptions(Long projectId);

}
