package cn.com.duiba.galaxy.console.manager;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.param.ProjectNewOrUpdateParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectCopyParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectNewParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectQueryParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectUpdateParam;
import cn.com.duiba.galaxy.console.model.vo.IdentityVo;
import cn.com.duiba.galaxy.console.model.vo.project.PageProjectVo;
import cn.com.duiba.galaxy.console.model.vo.project.ProjectQueryVo;

/**
 * 项目业务服务
 *
 * @author zhangdaqing
 * @Date 2022/9/29 16:09
 **/
public interface ProjectManager {
    /**
     * 新建项目
     *
     * @param param
     * @return
     */
    Long newProject(ProjectNewParam param);

    /**
     * 更新项目
     *
     * @param param 参数
     * @return {@link Boolean}
     */
    Boolean updateProject(ProjectUpdateParam param) throws BizException;


    /**
     * 根据项目id获取项目信息
     *
     * @param projectId 项目id
     * @return {@link ProjectQueryVo}
     */
    ProjectQueryVo getProjectByProjectId(Long projectId);


    /**
     * 更新应用程序id
     *
     * @param projectId 项目id
     * @param appId     开发者应用id
     * @return {@link Boolean}
     */
    Boolean updateAppId(Long projectId, Long appId);

    /**
     * 列表项目
     *
     * @param queryParam 查询参数
     * @return {@link PageProjectVo}
     */
    PageProjectVo listProjects(ProjectQueryParam queryParam);

    /**
     * 创建"模版活动"
     * 注：仅供积分商城使用
     *
     * @param projectNewOrUpdateParam 项目参数
     * @return {@link Long}
     * @throws BizException 业务异常
     */
    Long createForMall(ProjectNewOrUpdateParam projectNewOrUpdateParam) throws BizException;

    /**
     * 更新"模版活动"
     * 注：仅供积分商城使用
     *
     * @param param 参数
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean updateForMall(ProjectNewOrUpdateParam param) throws BizException;

    /**
     * 更新项目状态
     *
     * @param projectId 项目id
     * @param state     状态
     * @return {@link Boolean}
     */
    Boolean updateState(Long projectId, Integer state);

    /**
     * 获取首页访问url
     *
     * @param projectId 项目id
     * @return {@link String}
     */
    String getIndexUrl(Long projectId, Long appId);


    /**
     * 根据类型列表所有用户身份
     *
     * @param type  类型
     * @param appId 应用id
     * @return {@link IdentityVo}
     */
    IdentityVo listAllIdentityByType(Integer type, Long appId);


    boolean copyProject(ProjectCopyParam param);

    /**
     * 获取准备复制项目
     *
     * @param projectId 项目id
     * @return {@link ProjectQueryVo}
     */
    ProjectQueryVo getReadyCopyProject(Long projectId);

    /**
     * 获取项目预览url
     *
     * @param projectId 项目id
     * @return {@link String}
     */
    String getPreviewUrl(Long projectId);
}
