package cn.com.duiba.galaxy.console.manager;

import cn.com.duiba.galaxy.basic.model.entity.PrototypeJarEntity;
import cn.com.duiba.galaxy.console.model.param.prototype.CrossPushPrototypeParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeQueryParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeSaveParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeUpdateParam;
import cn.com.duiba.galaxy.console.model.param.prototype.SimplePrototypeParam;
import cn.com.duiba.galaxy.console.model.vo.PagePrototypeVo;
import cn.com.duiba.galaxy.console.model.vo.prototype.PrototypeVo;

import java.util.Map;
import java.util.concurrent.Future;

/**
 * @author zhangdaqing
 * @Date 2022/9/29 10:27
 * @desc 原型业务服务
 **/
public interface PrototypeManager {

    /**
     * @param param
     * @return
     * @throws Exception
     */
    boolean newPrototype(PrototypeSaveParam param);


    /**
     * 获取原型
     *
     * @param param 参数
     * @return {@link PrototypeVo}
     */
    PrototypeVo getPrototype(SimplePrototypeParam param);


    /**
     * 列表原型
     *
     * @param param 参数
     * @return {@link PagePrototypeVo}
     */
    PagePrototypeVo listPrototypes(PrototypeQueryParam param);


    /**
     * 更新原型
     *
     * @param param 参数
     * @return {@link Boolean}
     */
    Boolean updatePrototype(PrototypeUpdateParam param, Future<PrototypeJarEntity> task) throws Exception;


    /**
     * 获取主页皮肤
     *
     * @param prototypeId 原型id
     * @return {@link String}
     */
    String getSkinOfIndex(Long prototypeId);


    /**
     * 复制原型
     *
     * @param prototypeId 原型id
     * @return {@link Boolean}
     */
    Boolean copyPrototype(Long prototypeId);

    /**
     * 推送原型
     *
     * @param param 参数
     * @return {@link Boolean}
     */
    Boolean pushPrototype(CrossPushPrototypeParam param);

    /**
     * 接收并保存原型
     *
     * @param map 地图
     * @return {@link Boolean}
     */
    Boolean receiveAndSavePrototype(Map<String, String> map);


    /**
     * 更新原型状态
     *
     * @param prototypeId 原型id
     * @param state       状态
     */
    void updatePrototypeState(Long prototypeId, Integer state);
}
